<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use App\Mail\MailNotification;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class MailNotificationQueue implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $content;
    public $route;
    public $email;
    public $subjectEmail;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($content,$route,$email,$subjectEmail)
    {
        $this->content = $content;
        $this->route = $route;
        $this->email = $email;
        $this->subjectEmail = $subjectEmail;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $MailNotification = new MailNotification($this->content, $this->route,$this->subjectEmail);
        Mail::to($this->email)->send($MailNotification);
    }
}
